ORCA/M Asm65816 2.1.0

0001 D301                       title 'ROMDataMgr' 
0002 D301              **********************************************************************
0003 D301              *
0004 D301              * ROMDataMgr
0005 D301              * Copyright (C) 1989
0006 D301              * Apple Computer, Inc.
0007 D301              * All Rights Reserved
0008 D301              *
0009 D301              * This file contains the routines
0010 D301              *
0011 D301              *      GetROMResource
0012 D301              *      ReleaseROMResource
0013 D301              *
0014 D301              *
0015 D301              * These routines will allow ROM code to take advantage of resources when
0016 D301              * they are available by checking to see if a resource exists and loading it
0017 D301              * for the tool if needed. If the resource is not needed, this routine will
0018 D301              * simply return a fake handle to a ROM resource. 
0019 D301              *
0020 D301              * Version 1.0       Mensch
0021 D301              *    1/16/89        Initial version
0022 D301              *
0023 D301              *    2/17/89        Yee
0024 D301              *                   Changed size of bounds rect for the edit line control.
0025 D301              *                   Did not allow enough room for 3 chars. X2 changed from
0026 D301              *                   241 to 247. BRC #41036
0027 D301              *
0028 D301              *    2/23/89        Mensch
0029 D301              *                   Changed keytrans table to fix bugs reported in
0030 D301              *                   BRC #44583
0031 D301              *
0032 D301              **********************************************************************
0033 D301                       include 'all.macros' 
0034 D301                       include 'mt.equates.asm' 
0035 D301                       include '::sys.equs.asm' 
0036 D301
0037 D301                       EJECT 
0038 D301              *******************************************************************************
0039 D301              *
0040 D301              ROMDataArea RECORD 
0041 D301                       import w320start 
0042 D301                       import w640start 
0043 D301              *
0044 D301              * Description:      This area contains ROM resources that are used by ALL tools
0045 D301              *                   feel free to add to this list any time you want, HOWEVER
0046 D301              *                   try not to remove any data without making sure no one else
0047 D301              *                   is using it! The format of each "Resource" is:
0048 D301              *
0049 D301              *                   theType - WORD type of resource (must match res mgr types
0050 D301              *                   theID - LONG Unique 4 byte integer for this type of resource
0051 D301              *                   thePtr - LONG pointer to the raw data
0052 D301              *
0053 D301              *                   the table MUST terminate with an entry filled with blanks
0054 D301              *                   following the table, you can define any data you want. All
0055 D301              *                   ROM data should be in here.
0056 D301              *
0057 D301              *                   ID Conventions. It would be nice if we all followed simple
0058 D301              *                   guidelines for creating ID numbers for our resources.
0059 D301              *                   the ID should be in the following format
0060 D301              *
0061 D301              *                   $0FFFttii
0062 D301              *                     where tt is the tool set number and ii is a unique
0063 D301              *                     id number for that toolset.
0064 D301              *
0065 D301              *******************************************************************************
0066 D301              SizeofEntry  equ   10
0067 D301
0068 D301 FF FF        TypeList DC W:$FFFF                     ; first resource is a sample...
0069 D303 01 00 00 00  IDList   DC L:1                         ; please don't remove...
0070 D307 07 D3 FD 00  HandleTbl DC L:HandleTbl                ; sampleData
0071 D30B
0072 D30B              ; Entry for Font Manager ChooseFont templates here!
0073 D30B 0E 80                 DC W:$800E                     ; resource Type
0074 D30D 01 1B FF 0F           DC L:$0FFF1B01                 ; font manager window #1
0075 D311 33 D3 FD 00           DC L:w320Start
0076 D315
0077 D315 0E 80                 DC W:$800E                     ; res type
0078 D317 02 1B FF 0F           DC L:$0FFF1B02                 ; font manager window #2
0079 D31B BF D3 FD 00           DC L:w640Start
0080 D31F
0081 D31F                       IF Big=1 THEN 
0082 D31F              ; Entry for Event manager
0083 D31F              ; Default ID is now $FF instead of $01
0084 D31F 21 80                 DC W:$8021                     ; res Type Ktrans table
0085 D321 FF 06 FF 0F           DC L:$0FFF06FF                 ; ID Number
0086 D325 BB D6 FD 00           DC L:DefkTransTbl              ; default ktrans table
0087 D329                       ENDIF 
0088 D329              ;
0089 D329              ; END OF ID TABLE: DO NOT MODIFY THIS NEXT RECORD
0090 D329 00 00                 DC W:$0000
0091 D32B 00 00 00 00           DC L:$00000000
0092 D32F 00 00 00 00           DC L:$00000000
0093 D333
0094 D333                       EndR 
0095 D333
0096 D333              ;
0097 D333              ChooseFontStuff proc export 
0098 D333                       export w320start 
0099 D333                       export w640start 
0100 D333
0101 D333              *-------------- Window Stuff for ChooseFont --------------------
0102 D333              ; Equates for ChooseFont item ID's
0103 D333              MDListID equ   1
0104 D333              SizeListID equ   2
0105 D333              SizeEditID equ   3
0106 D333              OKID     equ   4
0107 D333              CancelID equ   5
0108 D333              ; these next style ID's must be in order...
0109 D333              PlainSID equ   6
0110 D333              BoldSID  equ   7
0111 D333              ItalicSID equ   8
0112 D333              UnderSID equ   9
0113 D333              OutlineSID equ   10
0114 D333              ShadowSID equ   11
0115 D333              LastSID  equ   12
0116 D333              ;
0117 D333              stat1ID  equ   12
0118 D333              stat2ID  equ   13
0119 D333              stat3ID  equ   14
0120 D333              styleFrameID equ   $42
0121 D333              ;
0122 D333              ; RefCon Equates for ChooseFont controls
0123 D333              useNILHit equ   0
0124 D333              useFontHit equ   1
0125 D333              useSizeHit equ   2
0126 D333              useOtherHit equ   3
0127 D333              useOKHit equ   4
0128 D333              useCancelHit equ   5
0129 D333              usePlainHit equ   6
0130 D333              useStyleHit equ   7
0131 D333
0132 D333              W320Start  
0133 D333 50 00                 DC W:W320_End-W320Start        ;$50        ;wind_end-wind_size
0134 D335 21 20                 DC W:%0010000000100001
0135 D337 00 00 00 00           DC L:0
0136 D33B 00 00 00 00           DC L:0
0137 D33F 00 00 00 00           DC W:0,0,0,0
0138 D347 00 00 00 00           DC L:0
0139 D34B 00 00                 DC W:0
0140 D34D 00 00                 DC W:0
0141 D34F 00 00                 DC W:0
0142 D351 00 00                 DC W:0
0143 D353 00 00                 DC W:0
0144 D355 00 00                 DC W:0
0145 D357 00 00                 DC W:0                         ;Number of pixels to scroll vertically.
0146 D359 00 00                 DC W:0                         ;Number of pixels to scroll horizontally.
0147 D35B 00 00                 DC W:0                         ;Number of pixels to page vertically.
0148 D35D 00 00                 DC W:0                         ;Number of pixels to page horizontally.
0149 D35F 00 00 00 00           DC L:0                         ;Infomation bar text string.
0150 D363 00 00                 DC W:0                         ;Height of information bar.
0151 D365 00 00 00 00           DC L:0                         ;DefProc.
0152 D369 00 00 00 00           DC L:0                         ;Routine to draw info. bar.
0153 D36D 00 00 00 00           DC L:0                         ;Routine to draw content.
0154 D371 19 00 14 00           DC W:25,20,185,300             ;window position
0155 D379 FF FF FF FF           DC L:$FFFFFFFF                 ;Plane to put window up in.
0156 D37D 83 D3 FD 00           DC L:w320CtlLst                ;Address of array of control pointers.
0157 D381 03 00                 DC W:3                         ; control template list of ptrs...
0158 D383              w320_end  
0159 D383
0160 D383              w320CtlLst  
0161 D383 4B D4 FD 00           DC L:w640MDList,w640SizeList,w640SizeEdit,w320OKButton
0162 D393 29 D5 FD 00           DC L:w320CanButton,w640plainS,w640BoldS,w640ItalicS
0163 D3A3 A7 D5 FD 00           DC L:w640UnderS,w640OutLineS,w640ShadowS,w640Stat1
0164 D3B3 27 D6 FD 00           DC L:w640Stat2,w640Stat3
0165 D3BB 00 00 00 00           DC L:0
0166 D3BF
0167 D3BF              W640Start  
0168 D3BF 50 00                 DC W:W640_End-W640Start        ;$50        ;wind_end-wind_size
0169 D3C1 21 20                 DC W:%0010000000100001
0170 D3C3 00 00 00 00           DC L:0
0171 D3C7 00 00 00 00           DC L:0
0172 D3CB 00 00 00 00           DC W:0,0,0,0
0173 D3D3 00 00 00 00           DC L:0
0174 D3D7 00 00                 DC W:0
0175 D3D9 00 00                 DC W:0
0176 D3DB 00 00                 DC W:0
0177 D3DD 00 00                 DC W:0
0178 D3DF 00 00                 DC W:0
0179 D3E1 00 00                 DC W:0
0180 D3E3 00 00                 DC W:0                         ;Number of pixels to scroll vertically.
0181 D3E5 00 00                 DC W:0                         ;Number of pixels to scroll horizontally.
0182 D3E7 00 00                 DC W:0                         ;Number of pixels to page vertically.
0183 D3E9 00 00                 DC W:0                         ;Number of pixels to page horizontally.
0184 D3EB 00 00 00 00           DC L:0                         ;Infomation bar text string.
0185 D3EF 00 00                 DC W:0                         ;Height of information bar.
0186 D3F1 00 00 00 00           DC L:0                         ;DefProc.
0187 D3F5 00 00 00 00           DC L:0                         ;Routine to draw info. bar.
0188 D3F9 00 00 00 00           DC L:0                         ;Routine to draw content.
0189 D3FD 19 00 AF 00           DC W:25,175,185,465            ;window position
0190 D405 FF FF FF FF           DC L:$FFFFFFFF                 ;Plane to put window up in.
0191 D409 0F D4 FD 00           DC L:w640CtlLst                ;Address of array of control pointers.
0192 D40D 03 00                 DC W:3                         ; control template list of ptrs...
0193 D40F              w640_end  
0194 D40F
0195 D40F              w640CtlLst  
0196 D40F 4B D4 FD 00           DC L:w640MDList,w640SizeList,w640SizeEdit,w640OKButton
0197 D41F ED D4 FD 00           DC L:w640CanButton,w640plainS,w640BoldS,w640ItalicS
0198 D42F A7 D5 FD 00           DC L:w640UnderS,w640OutLineS,w640ShadowS,w640Stat1
0199 D43F 27 D6 FD 00           DC L:w640Stat2,w640Stat3
0200 D447 00 00 00 00           DC L:0
0201 D44B
0202 D44B 08 00        w640MDList DC W:8                       ; number of parameters
0203 D44D 01 00 00 00           DC L:MDListID                  ; app ID
0204 D451 0E 00 0F 00           DC W:14,15,76,250              ; font rectangle
0205 D459 00 00 00 89           DC L:$89000000                 ; procref
0206 D45D 00 00                 DC W:0                         ; flags (visible)
0207 D45F 00 10                 DC W:$1000                     ;moreflags
0208 D461 01 00 00 00           DC L:useFontHit                ;refcon
0209 D465 00 00                 DC W:0                         ; number of members
0210 D467 00 00                 DC W:0                         ;view size
0211 D469 06 00                 DC W:2+4                       ;type of members
0212 D46B 01 00                 DC W:1                         ;starting member
0213 D46D 00 00 00 00           DC L:0                         ;List drawing routine
0214 D471 0A 00                 DC W:10                        ;height of member in pixels
0215 D473 08 00                 DC W:8                         ;size of each member record
0216 D475 00 00 00 00           DC L:0                         ;pointer to member list
0217 D479 00 00 00 00           DC L:0
0218 D47D
0219 D47D 0E 00        w640SizeList DC W:14
0220 D47F 02 00 00 00           DC L:SizeListID
0221 D483 5A 00 82 00           DC W:90,130,152,173
0222 D48B 00 00 00 89           DC L:$89000000
0223 D48F 00 00                 DC W:0
0224 D491 00 10                 DC W:$1000                     ;moreflags
0225 D493 02 00 00 00           DC L:useSizeHit                ;refcon
0226 D497 00 00                 DC W:0                         ;listsize
0227 D499 00 00                 DC W:0                         ;listView
0228 D49B 02 00                 DC W:2                         ;listType
0229 D49D 01 00                 DC W:1                         ;listStart
0230 D49F 00 00 00 00           DC L:0                         ;listDraw (should be patched later when list created)
0231 D4A3 0A 00                 DC W:10                        ;listMemHeight
0232 D4A5 05 00                 DC W:5                         ;listMemSize
0233 D4A7 00 00 00 00           DC L:0                         ;listRef set by newList2...
0234 D4AB 00 00 00 00           DC L:0                         ;colorTableRef
0235 D4AF
0236 D4AF 08 00        w640SizeEdit DC W:8                     ; size of the record
0237 D4B1 03 00 00 00           DC L:SizeEditID                ; app ID
0238 D4B5 65 00 D3 00           DC W:101,211,112,247
0239 D4BD 00 00 00 83           DC L:$83000000
0240 D4C1 00 00                 DC W:0                         ; flags (visible)
0241 D4C3 00 10                 DC W:$1000                     ; procnotref default is ptr
0242 D4C5 03 00 00 00           DC L:useOtherHit               ; refcon
0243 D4C9 03 00                 DC W:3                         ; max string length
0244 D4CB 00 00 00 00           DC L:0                         ; no default...
0245 D4CF
0246 D4CF 07 00        w640OKButton DC W:7                     ; size of the record
0247 D4D1 04 00 00 00           DC L:OKId                      ; appID
0248 D4D5 8C 00 CD 00           DC W:140,205,153,275
0249 D4DD 00 00 00 80           DC L:$80000000
0250 D4E1 01 00                 DC W:1
0251 D4E3 00 10                 DC W:$1000
0252 D4E5 04 00 00 00           DC L:useOKHit
0253 D4E9 86 D6 FD 00           DC L:OKStr
0254 D4ED
0255 D4ED 07 00        w640CanButton DC W:7
0256 D4EF 05 00 00 00           DC L:CancelID
0257 D4F3 7A 00 CD 00           DC W:122,205,135,275
0258 D4FB 00 00 00 80           DC L:$80000000
0259 D4FF 00 00                 DC W:0
0260 D501 00 10                 DC W:$1000
0261 D503 05 00 00 00           DC L:useCancelHit
0262 D507 89 D6 FD 00           DC L:CancelStr
0263 D50B
0264 D50B 07 00        w320OKButton DC W:7                     ; size of the record
0265 D50D 04 00 00 00           DC L:OKId                      ; appID
0266 D511 8C 00 CD 00           DC W:140,205,153,265
0267 D519 00 00 00 80           DC L:$80000000
0268 D51D 01 00                 DC W:1
0269 D51F 00 10                 DC W:$1000
0270 D521 04 00 00 00           DC L:useOKHit
0271 D525 86 D6 FD 00           DC L:OKStr
0272 D529
0273 D529 07 00        w320CanButton DC W:7
0274 D52B 05 00 00 00           DC L:CancelID
0275 D52F 7A 00 CD 00           DC W:122,205,135,265
0276 D537 00 00 00 80           DC L:$80000000
0277 D53B 00 00                 DC W:0
0278 D53D 00 10                 DC W:$3000
0279 D53F 05 00 00 00           DC L:useCancelHit
0280 D543 89 D6 FD 00           DC L:CancelStr
0281 D547
0282 D547 08 00        w640plainS DC W:8
0283 D549 06 00 00 00           DC L:PlainSID
0284 D54D 5A 00 11 00           DC W:90,17,100,122
0285 D555 00 00 00 82           DC L:$82000000
0286 D559 00 00                 DC W:0                         ; flags (visible)
0287 D55B 00 10                 DC W:$1000                     ; MoreFlags
0288 D55D 06 00 00 00           DC L:usePlainHit
0289 D561 90 D6 FD 00           DC L:Style1Str
0290 D565 00 00                 DC W:0                         ;initial value
0291 D567
0292 D567 08 00        w640BoldS DC W:8
0293 D569 07 00 00 00           DC L:BoldSID
0294 D56D 65 00 11 00           DC W:101,17,111,122
0295 D575 00 00 00 82           DC L:$82000000
0296 D579 00 00                 DC W:0                         ; flags (visible)
0297 D57B 00 10                 DC W:$1000                     ; MoreFlags
0298 D57D 07 00 00 00           DC L:useStyleHit
0299 D581 96 D6 FD 00           DC L:Style2Str
0300 D585 00 00                 DC W:0
0301 D587
0302 D587 08 00        w640ItalicS DC W:8
0303 D589 08 00 00 00           DC L:ItalicSID
0304 D58D 70 00 11 00           DC W:112,17,122,122
0305 D595 00 00 00 82           DC L:$82000000
0306 D599 00 00                 DC W:0                         ; flags (visible)
0307 D59B 00 10                 DC W:$1000                     ; MoreFlags
0308 D59D 07 00 00 00           DC L:useStyleHit
0309 D5A1 9B D6 FD 00           DC L:Style3Str
0310 D5A5 00 00                 DC W:0
0311 D5A7
0312 D5A7 08 00        w640UnderS DC W:8
0313 D5A9 09 00 00 00           DC L:UnderSID
0314 D5AD 7B 00 11 00           DC W:123,17,133,122
0315 D5B5 00 00 00 82           DC L:$82000000
0316 D5B9 00 00                 DC W:0                         ; flags (visible)
0317 D5BB 00 10                 DC W:$1000                     ; MoreFlags
0318 D5BD 07 00 00 00           DC L:useStyleHit
0319 D5C1 A2 D6 FD 00           DC L:Style4Str
0320 D5C5 00 00                 DC W:0
0321 D5C7
0322 D5C7 08 00        w640OutLineS DC W:8
0323 D5C9 0A 00 00 00           DC L:OutlineSID
0324 D5CD 86 00 11 00           DC W:134,17,144,122
0325 D5D5 00 00 00 82           DC L:$82000000
0326 D5D9 00 00                 DC W:0                         ; flags (visible)
0327 D5DB 00 10                 DC W:$1000                     ; MoreFlags
0328 D5DD 07 00 00 00           DC L:useStyleHit
0329 D5E1 AC D6 FD 00           DC L:Style5Str
0330 D5E5 00 00                 DC W:0
0331 D5E7
0332 D5E7 08 00        w640ShadowS DC W:8
0333 D5E9 0B 00 00 00           DC L:ShadowSID
0334 D5ED 91 00 11 00           DC W:145,17,155,122
0335 D5F5 00 00 00 82           DC L:$82000000
0336 D5F9 00 00                 DC W:0                         ; flags (visible)
0337 D5FB 00 10                 DC W:$1000                     ; MoreFlags
0338 D5FD 07 00 00 00           DC L:useStyleHit
0339 D601 B4 D6 FD 00           DC L:Style6Str
0340 D605 00 00                 DC W:0
0341 D607
0342 D607 08 00        w640Stat1 DC W:8
0343 D609 0C 00 00 00           DC L:stat1ID
0344 D60D 04 00 0F 00           DC W:4,15,14,122
0345 D615 00 00 00 81           DC L:$81000000
0346 D619 01 FF                 DC W:$FF01                     ; pstring
0347 D61B 00 10                 DC W:$1000
0348 D61D 00 00 00 00           DC L:useNILHit
0349 D621 68 D6 FD 00           DC L:FontStr+1
0350 D625 05 00                 DC W:5
0351 D627
0352 D627 08 00        w640Stat2 DC W:8
0353 D629 0D 00 00 00           DC L:stat2ID
0354 D62D 59 00 CD 00           DC W:89,205,99,280
0355 D635 00 00 00 81           DC L:$81000000
0356 D639 01 FF                 DC W:$FF01                     ; pstring
0357 D63B 00 10                 DC W:$1000
0358 D63D 00 00 00 00           DC L:useNILHit
0359 D641 75 D6 FD 00           DC L:SizeStr+1
0360 D645 05 00                 DC W:5
0361 D647
0362 D647 08 00        w640Stat3 DC W:8
0363 D649 0E 00 00 00           DC L:stat3ID
0364 D64D 4E 00 11 00           DC W:78,17,88,205
0365 D655 00 00 00 81           DC L:$81000000
0366 D659 01 FF                 DC W:$FF01                     ; pstring
0367 D65B 00 10                 DC W:$1000
0368 D65D 00 00 00 00           DC L:useNILHit
0369 D661 6E D6 FD 00           DC L:StyleStr+1
0370 D665 06 00                 DC W:6
0371 D667
0372 D667 05 46 6F 6E  FontStr  DC C:'Font:'
0373 D66D 06 53 74 79  StyleStr DC C:'Style:'
0374 D674 05 53 69 7A  SizeStr  DC C:'Size:'
0375 D67A 05 4F 74 68  OtherStr1 DC C:'Other'
0376 D680 05 53 69 7A  OtherStr2 DC C:'Size:'
0377 D686 02 4F 4B     OKStr    DC C:'OK'
0378 D689 06 43 61 6E  CancelStr DC C:'Cancel'
0379 D690 05 50 6C 61  Style1Str DC C:'Plain'
0380 D696 04 42 6F 6C  Style2Str DC C:'Bold'
0381 D69B 06 49 74 61  Style3Str DC C:'Italic'
0382 D6A2 09 55 6E 64  Style4Str DC C:'Underline'
0383 D6AC 07 4F 75 74  Style5Str DC C:'Outline'
0384 D6B4 06 53 68 61  Style6Str DC C:'Shadow'
0385 D6BB
0386 D6BB              ; END of Font manager data area
0387 D6BB                       EndP 
0388 D6BB
0389 D6BB
0390 D6BB              TranslateTable RECORD  
0391 D6BB
0392 D6BB                       IF Big=1 THEN 
0393 D6BB
0394 D6BB                       export DefkTransTbl
0395 D6BB              DefkTransTbl  
0396 D6BB 00 01 02 03           dosomeBytes 0,127              ; generate normal keys, no sub
0397 D73B              ; option substitution table starts here...
0398 D73B              ; NOTE that when a printable mac keystroke exists for this table,
0399 D73B              ; we will use the same keystroke that the mac uses
0400 D73B 00 01 02 03           doSomeBytes 0,31               ; generate option control, no change
0401 D75B              ;
0402 D75B              ; the following table generated by:
0403 D75B              ;set x 32
0404 D75B              ;Loop
0405 D75B              ;    echo "<tab>dc.B ${x}<tab>;sub for option - {x}" ;
0406 D75B              ;    set x `evaluate {x}+1` ;
0407 D75B              ;    If {X}>127 
0408 D75B              ;        break
0409 D75B              ;    else
0410 D75B              ;        continue
0411 D75B              ;    end;
0412 D75B              ;End  
0413 D75B
0414 D75B CA                    DC B:$CA                       ;sub for option - 32
0415 D75C DA                    DC B:$DA                       ;sub for option - 33
0416 D75D AE                    DC B:$AE                       ;sub for option - 34
0417 D75E DC                    DC B:$DC                       ;sub for option - 35
0418 D75F DD                    DC B:$DD                       ;sub for option - 36
0419 D760 DE                    DC B:$DE                       ;sub for option - 37
0420 D761 E0                    DC B:$E0                       ;sub for option - 38
0421 D762 BE                    DC B:$BE                       ;sub for option - $27
0422 D763 E1                    DC B:$E1                       ;sub for option - 40
0423 D764 E2                    DC B:$E2                       ;sub for option - 41
0424 D765 A1                    DC B:$A1                       ;sub for option - 42
0425 D766 B1                    DC B:$B1                       ;sub for option - +
0426 D767 B2                    DC B:$B2                       ;sub for option - ,
0427 D768 D0                    DC B:$D0                       ;sub for option - -
0428 D769 B3                    DC B:$B3                       ;sub for option - .
0429 D76A D6                    DC B:$D6                       ;sub for option - /
0430 D76B BC                    DC B:$BC                       ;sub for option - $30
0431 D76C C1                    DC B:$C1                       ;sub for option - 49
0432 D76D AA                    DC B:$AA                       ;sub for option - 50
0433 D76E A3                    DC B:$A3                       ;sub for option - 51
0434 D76F A2                    DC B:$A2                       ;sub for option - 52
0435 D770 B0                    DC B:$B0                       ;sub for option - 53
0436 D771 A4                    DC B:$A4                       ;sub for option - 54
0437 D772 A6                    DC B:$A6                       ;sub for option - 55
0438 D773 A5                    DC B:$A5                       ;sub for option - 56
0439 D774 BB                    DC B:$BB                       ;sub for option - 57
0440 D775 F2                    DC B:$F2                       ;sub for option - 58
0441 D776 C9                    DC B:$C9                       ;sub for option - 59
0442 D777 F8                    DC B:$F8                       ;sub for option - 60
0443 D778 AD                    DC B:$AD                       ;sub for option - 61
0444 D779 F9                    DC B:$F9                       ;sub for option - 62
0445 D77A C0                    DC B:$C0                       ;sub for option - 63
0446 D77B DB                    DC B:$DB                       ;sub for option - $40
0447 D77C 81                    DC B:$81                       ;sub for option - 65
0448 D77D F5                    DC B:$F5                       ;sub for option - 66
0449 D77E 82                    DC B:$82                       ;sub for option - 67
0450 D77F EB                    DC B:$EB                       ;sub for option - 68
0451 D780 E4                    DC B:$E4                       ;sub for option - 69
0452 D781 EC                    DC B:$EC                       ;sub for option - 70
0453 D782 ED                    DC B:$ED                       ;sub for option - 71
0454 D783 EE                    DC B:$EE                       ;sub for option - 72
0455 D784 E9                    DC B:$E9                       ;sub for option - 73
0456 D785 EF                    DC B:$EF                       ;sub for option - J
0457 D786 F0                    DC B:$F0                       ;sub for option - K
0458 D787 F1                    DC B:$F1                       ;sub for option - L
0459 D788 F7                    DC B:$F7                       ;sub for option - M
0460 D789 F6                    DC B:$F6                       ;sub for option - N
0461 D78A AF                    DC B:$AF                       ;sub for option - O
0462 D78B B8                    DC B:$B8                       ;sub for option - P
0463 D78C CE                    DC B:$CE                       ;sub for option - Q
0464 D78D E5                    DC B:$E5                       ;sub for option - R
0465 D78E EA                    DC B:$EA                       ;sub for option - S
0466 D78F E6                    DC B:$E6                       ;sub for option - T
0467 D790 E8                    DC B:$E8                       ;sub for option - U
0468 D791 D7                    DC B:$D7                       ;sub for option - V
0469 D792 E3                    DC B:$E3                       ;sub for option - W
0470 D793 F4                    DC B:$F4                       ;sub for option - X
0471 D794 E7                    DC B:$E7                       ;sub for option - Y
0472 D795 F3                    DC B:$F3                       ;sub for option - Z
0473 D796 D2                    DC B:$D2                       ;sub for option - [
0474 D797 C7                    DC B:$C7                       ;sub for option - \
0475 D798 D4                    DC B:$D4                       ;sub for option - ]
0476 D799 DF                    DC B:$DF                       ;sub for option - 94
0477 D79A D1                    DC B:$D1                       ;sub for option - 95
0478 D79B 60                    DC B:$60                       ;sub for option - $60
0479 D79C 8C                    DC B:$8C                       ;sub for option - a
0480 D79D BA                    DC B:$BA                       ;sub for option - b
0481 D79E 8D                    DC B:$8D                       ;sub for option - c
0482 D79F B6                    DC B:$B6                       ;sub for option - d
0483 D7A0 AB                    DC B:$AB                       ;sub for option - e
0484 D7A1 C4                    DC B:$C4                       ;sub for option - f
0485 D7A2 A9                    DC B:$A9                       ;sub for option - g
0486 D7A3 FA                    DC B:$FA                       ;sub for option - h
0487 D7A4 5E                    DC B:$5E                       ;sub for option - i
0488 D7A5 C6                    DC B:$C6                       ;sub for option - j
0489 D7A6 FB                    DC B:$FB                       ;sub for option - k
0490 D7A7 C2                    DC B:$C2                       ;sub for option - l
0491 D7A8 B5                    DC B:$B5                       ;sub for option - m
0492 D7A9 7E                    DC B:$7E                       ;sub for option - n
0493 D7AA BF                    DC B:$BF                       ;sub for option - o
0494 D7AB B9                    DC B:$B9                       ;sub for option - p
0495 D7AC CF                    DC B:$CF                       ;sub for option - q
0496 D7AD A8                    DC B:$A8                       ;sub for option - r
0497 D7AE A7                    DC B:$A7                       ;sub for option - s
0498 D7AF A0                    DC B:$A0                       ;sub for option - t
0499 D7B0 AC                    DC B:$AC                       ;sub for option - u
0500 D7B1 C3                    DC B:$C3                       ;sub for option - v
0501 D7B2 B7                    DC B:$B7                       ;sub for option - w
0502 D7B3 C5                    DC B:$C5                       ;sub for option - x
0503 D7B4 B4                    DC B:$B4                       ;sub for option - y
0504 D7B5 BD                    DC B:$BD                       ;sub for option - z
0505 D7B6 D3                    DC B:$D3                       ;sub for option - {
0506 D7B7 C8                    DC B:$C8                       ;sub for option - |
0507 D7B8 D5                    DC B:$D5                       ;sub for option - }
0508 D7B9 D9                    DC B:$D9                       ;sub for option - ~
0509 D7BA 7F                    DC B:$7F                       ;sub for option - DEL
0510 D7BB              ; end Sub_Array here, now create the dead key table...
0511 D7BB              DeadKStart  
0512 D7BB              ; First, entry for grave accent
0513 D7BB 60 06                 DC B:$60,(GAStart-DeadKStart)/2
0514 D7BD              ; next carat over letter...
0515 D7BD 5E 0E                 DC B:$5E,(CAStart-DeadKStart)/2
0516 D7BF              ; accent over letter
0517 D7BF AB 15                 DC B:$AB,(ACStart-DeadKStart)/2
0518 D7C1              ; Tidl over letter
0519 D7C1 7E 1D                 DC B:$7E,(TCStart-DeadKStart)/2
0520 D7C3              ; oomlaut over letter
0521 D7C3 AC 24                 DC B:$AC,(OLStart-DeadKStart)/2
0522 D7C5              ; end of this table
0523 D7C5 00 00                 DC W:0
0524 D7C7              GAStart   
0525 D7C7 61 88                 DC B:'a',$88
0526 D7C9 41 CB                 DC B:'A',$CB
0527 D7CB 65 8F                 DC B:'e',$8F
0528 D7CD 69 93                 DC B:'i',$93
0529 D7CF 6F 98                 DC B:'o',$98
0530 D7D1 75 9D                 DC B:'u',$9D
0531 D7D3 20 60                 DC B:' ',$60
0532 D7D5 00 00                 DC W:$0000
0533 D7D7              CAStart   
0534 D7D7 61 89                 DC B:'a',$89
0535 D7D9 65 90                 DC B:'e',$90
0536 D7DB 69 94                 DC B:'i',$94
0537 D7DD 6F 99                 DC B:'o',$99
0538 D7DF 75 9E                 DC B:'u',$9E
0539 D7E1 20 5E                 DC B:' ',$5E
0540 D7E3 00 00                 DC W:$0000
0541 D7E5
0542 D7E5              ACStart   
0543 D7E5 45 83                 DC B:'E',$83
0544 D7E7 61 87                 DC B:'a',$87
0545 D7E9 65 8E                 DC B:'e',$8E
0546 D7EB 69 92                 DC B:'i',$92
0547 D7ED 6F 97                 DC B:'o',$97
0548 D7EF 75 9C                 DC B:'u',$9C
0549 D7F1 20 AB                 DC B:' ',$AB
0550 D7F3 00 00                 DC W:$0000
0551 D7F5
0552 D7F5              TCStart   
0553 D7F5 41 CC                 DC B:'A',$CC
0554 D7F7 4E 84                 DC B:'N',$84
0555 D7F9 4F CD                 DC B:'O',$CD
0556 D7FB 61 8B                 DC B:'a',$8B
0557 D7FD 6E 96                 DC B:'n',$96
0558 D7FF 6F 9B                 DC B:'o',$9B
0559 D801 00 00                 DC W:$0000
0560 D803
0561 D803              OLStart   
0562 D803 41 80                 DC B:'A',$80
0563 D805 4F 85                 DC B:'O',$85
0564 D807 55 86                 DC B:'U',$86
0565 D809 61 8A                 DC B:'a',$8A
0566 D80B 65 91                 DC B:'e',$91
0567 D80D 69 95                 DC B:'i',$95
0568 D80F 6F 9A                 DC B:'o',$9A
0569 D811 75 9F                 DC B:'u',$9F
0570 D813 79 D8                 DC B:'y',$D8
0571 D815 20 AC                 DC B:' ',$AC
0572 D817 00 00                 DC W:$0000
0573 D819              ; end ktrans table here
0574 D819                       ENDIF 
0575 D819
0576 D819                       ENDR 
0577 D819
0578 D819
0579 D819                       EJECT 
0580 D819              *******************************************************************************
0581 D819              *
0582 D819              GetROMResource PROC EXPORT 
0583 D819              *
0584 D819              * Description:      This call will return a 'handle' to the data requested by the
0585 D819              *                   ROM routine. This will either be a fake handle that exists
0586 D819              *                   only in ROM, or a real resource loaded from disk. The tool
0587 D819              *                   should not treat this resouce any different from a handle, 
0588 D819              *                   except that it is always to be treated as read only. The 
0589 D819              *                   parameters of this call are identical to those of the
0590 D819              *                   real resource manager. Please refer to then for further 
0591 D819              *                   details.
0592 D819              *
0593 D819              *
0594 D819              * Inputs:           On Stack
0595 D819              *                   |  previous contents  |
0596 D819              *                   +---------------------+
0597 D819              *                   |                     |
0598 D819              *                   +--    LongSpace    --+ LONG Room for result
0599 D819              *                   |                     |
0600 D819              *                   +---------------------+
0601 D819              *                   |   resource type     | WORD Type of resource to find
0602 D819              *                   +---------------------+
0603 D819              *                   |                     |
0604 D819              *                   +--   resource ID   --+ LONG ID of resource to load
0605 D819              *                   |                     |
0606 D819              *                   +---------------------+
0607 D819              *                   |                     | <- SP
0608 D819              *
0609 D819              *
0610 D819              *
0611 D819              * Outputs:          On Stack
0612 D819              *                   |  previous contents  |
0613 D819              *                   +---------------------+
0614 D819              *                   |                     |
0615 D819              *                   +--   Data Handle   --+ LONG Handle to data storage
0616 D819              *                   |                     |
0617 D819              *                   +---------------------+
0618 D819              *                   |                     | <- SP
0619 D819              *
0620 D819              *
0621 D819              * Errors:           Memory manager errors
0622 D819              *                   $0310   Requested data does not exist
0623 D819              *                           This can only happen if a ROM version of the data
0624 D819              *                           does not already exist.
0625 D819              *
0626 D819              * External Refs:
0627 D819              *
0628 D819              * Entry Points:
0629 D819              *
0630 D819              *******************************************************************************
0631 D819                       With ROMDataArea 
0632 D819              ;
0633 D819              ; Equates for use with our stack frame...
0634 D819              SaveDPage equ   1
0635 D819              RetAddr1 equ   SaveDPage+2
0636 D819              RetAddr2 equ   RetAddr1+3
0637 D819              resID    equ   RetAddr2+3
0638 D819              ResType  equ   ResID+4
0639 D819              result   equ   resType+2
0640 D819
0641 D819 0B                    phd                            ; save the current dpage
0642 D81A 3B                    tsc                            ; get the stack pointer
0643 D81B 5B                    tcd                            ; and make it the direct page...
0644 D81C
0645 D81C 64 0F                 stz   <result                  ; first zero out the result
0646 D81E 64 11                 stz   <result+2
0647 D820
0648 D820              ;
0649 D820              ; Since this tool is going to work with the resource manager, we will first 
0650 D820              ; test to see if the resource manager is running with the status call
0651 D820
0652 D820 F4 00 00              pea   $0000                    ; room for result
0653 D823 A2 1E 06 22           _ResourceStatus 
0654 D82A 68                    pla   
0655 D82B F0 20                 beq   UseROMData               ; if this is false, use the ROM data
0656 D82D
0657 D82D              ;
0658 D82D              ; If the resource manager is running, try to load the resource that we want.
0659 D82D
0660 D82D 48                    pha                            ; room for result
0661 D82E 48                    pha   
0662 D82F A5 0D                 lda   <ResType                 ; type of resource to load
0663 D831 48                    pha   
0664 D832 A5 0B                 lda   <ResID+2                 ; ID of resource to load
0665 D834 48                    pha   
0666 D835 A5 09                 lda   <ResID
0667 D837 48                    pha   
0668 D838 A2 1E 0E 22           _Loadresource                  ;attempt to load the resource from the file
0669 D83F 68                    pla                            ; get the result for a second...
0670 D840 FA                    plx   
0671 D841 B0 0A                 bcs   UseROMData               ; if an error occured, us the ROM resource
0672 D843              ;
0673 D843              ; If we get this far then we have loaded the resource from the resource file,
0674 D843              ; and we should just return its handle to the caller...
0675 D843
0676 D843 85 0F                 sta   <result                  ; store the result in result
0677 D845 86 11                 stx   <result+2
0678 D847 A0 00 00              ldy   #0                       ; error code ...
0679 D84A 82 4B 00              brl   GRRDone                  ; and end the call
0680 D84D
0681 D84D              ;
0682 D84D              UseROMData  
0683 D84D              ; This routine will be called when the apropriate resource is not available, it will
0684 D84D              ; look thru the ROM data tables and pick out the proper handle from the list. If it
0685 D84D              ; can not find a proper resource in the list, it will simply bomb with a data not
0686 D84D              ; found error
0687 D84D
0688 D84D A2 00 00              ldx   #0                       ; init our counter
0689 D850 BF 01 D3 FD  FindLoop lda   >TypeList,x              ; load in the first type
0690 D854 C5 0D                 cmp   <resType                 ; does it match our desired id?
0691 D856 D0 12                 bne   tryNext                  ; if not, try the next one
0692 D858 BF 03 D3 FD           lda   >IDList,x                ; next try the ID list
0693 D85C C5 09                 cmp   <ResID                   ; see if the ID matches
0694 D85E D0 0A                 bne   tryNext                  ; if not try the next one
0695 D860 BF 05 D3 FD           lda   >IDList+2,x              ; now the high byte of the ID
0696 D864 C5 0B                 cmp   <ResID+2
0697 D866 D0 02                 bne   tryNext
0698 D868 80 1C                 bra   FoundROMData             ; if all tests match, then we found the ROM data
0699 D86A              tryNext   
0700 D86A BF 01 D3 FD           lda   >TypeList,x              ; test to see if we are at the end of the list
0701 D86E 1F 03 D3 FD           ora   >IDList,x                ; by finding 0's in the type and ID field
0702 D872 1F 05 D3 FD           ora   >IDList+2,x
0703 D876 F0 08                 beq   NoROMData                ; if this is zero, then there is no ROM data
0704 D878 8A                    txa                            ; bump our counter
0705 D879 18                    clc   
0706 D87A 69 0A 00              adc   #SizeofEntry             ; by the size of each entry
0707 D87D AA                    tax                            ; and try the next one...
0708 D87E 80 D0                 bra   FindLoop
0709 D880              NoROMData  
0710 D880              ;
0711 D880              ; This routine places an error into Y and ends
0712 D880 A0 10 03              ldy   #$0310                   ; data not found error
0713 D883 82 12 00              brl   GRRDone
0714 D886
0715 D886              FoundROMData  
0716 D886              ;
0717 D886              ; This routine sets up the proper result and returns it to the caller.
0718 D886 8A                    txa                            ; put table offset into <A>
0719 D887 18                    clc                            ; and create a pointer to our pointer
0720 D888 69 07 D3              adc   #HandleTbl
0721 D88B 85 0F                 sta   <Result
0722 D88D A9 00 00              lda   #0
0723 D890 69 FD 00              adc   #HandleTbl>>16
0724 D893 85 11                 sta   <Result+2
0725 D895 A0 00 00              ldy   #0
0726 D898              ;
0727 D898              GRRDone   
0728 D898              ; This routine moves the return address on the stack and then tests <Y> for an
0729 D898              ; error code, and returns.
0730 D898
0731 D898 A5 03                 lda   <RetAddr1                ; move the return address
0732 D89A 85 09                 sta   <ResID
0733 D89C A5 05                 lda   <RetAddr1+2
0734 D89E 85 0B                 sta   <ResID+2
0735 D8A0 A5 07                 lda   <RetAddr1+4
0736 D8A2 85 0D                 sta   <ResID+4
0737 D8A4
0738 D8A4 2B                    pld                            ; recover the direct page
0739 D8A5 FA                    plx                            ; remove 6 bytes of data
0740 D8A6 FA                    plx   
0741 D8A7 FA                    plx   
0742 D8A8
0743 D8A8 98                    tya                            ; put the return address into <A>
0744 D8A9 C9 01 00              cmp   #1                       ; set the carry
0745 D8AC 6B                    rtl                            ; and leave
0746 D8AD                       EndP 
0747 D8AD
0748 D8AD                       EJECT 
0749 D8AD              *******************************************************************************
0750 D8AD              *
0751 D8AD              ReleaseROMResource PROC EXPORT 
0752 D8AD              *
0753 D8AD              * Description:      This call releases a resource that was given by the 
0754 D8AD              *                   GetROMResource call. It should be made for all data
0755 D8AD              *                   that you retrieve even if its in firmware.
0756 D8AD              *
0757 D8AD              *
0758 D8AD              * Inputs:           On Stack
0759 D8AD              *                   |  previous contents  |
0760 D8AD              *                   +---------------------+
0761 D8AD              *                   |   resource type     | WORD Type of resource to release
0762 D8AD              *                   +---------------------+
0763 D8AD              *                   |                     |
0764 D8AD              *                   +--   resource ID   --+ LONG ID of resource to release
0765 D8AD              *                   |                     |
0766 D8AD              *                   +---------------------+
0767 D8AD              *                   |                     | <- SP
0768 D8AD              *
0769 D8AD              *
0770 D8AD              *
0771 D8AD              *
0772 D8AD              *
0773 D8AD              * Outputs:          On Stack
0774 D8AD              *                   |  previous contents  |
0775 D8AD              *                   +---------------------+
0776 D8AD              *                   |                     | <- SP
0777 D8AD              *
0778 D8AD              *
0779 D8AD              * Errors:           Memory manager errors
0780 D8AD              *
0781 D8AD              * External Refs:
0782 D8AD              *
0783 D8AD              * Entry Points:
0784 D8AD              *
0785 D8AD              *******************************************************************************
0786 D8AD                       With ROMDataArea 
0787 D8AD              ;
0788 D8AD              ; Equates for use with our stack frame...
0789 D8AD              SaveDPage equ   1
0790 D8AD              RetAddr1 equ   SaveDPage+2
0791 D8AD              RetAddr2 equ   RetAddr1+3
0792 D8AD              resID    equ   RetAddr2+3
0793 D8AD              ResType  equ   ResID+4
0794 D8AD
0795 D8AD 0B                    phd                            ; save the current dpage
0796 D8AE 3B                    tsc                            ; get the stack pointer
0797 D8AF 5B                    tcd                            ; and make it the direct page...
0798 D8B0
0799 D8B0              ;
0800 D8B0              ; Since this tool is going to work with the resource manager, we will first 
0801 D8B0              ; test to see if the resource manager is running with the status call
0802 D8B0
0803 D8B0 F4 00 00              pea   $0000                    ; room for result
0804 D8B3 A2 1E 06 22           _ResourceStatus 
0805 D8BA 68                    pla   
0806 D8BB F0 1B                 beq   UseROMData               ; if this is false, use the ROM data
0807 D8BD
0808 D8BD              ;
0809 D8BD              ; If the resource manager is running, release the given resource.
0810 D8BD
0811 D8BD F4 03 00              pea   $0003                    ; set to highest purge factor
0812 D8C0 A5 0D                 lda   <ResType                 ; type of resource to release
0813 D8C2 48                    pha   
0814 D8C3 A5 0B                 lda   <ResID+2                 ; ID of resource to release
0815 D8C5 48                    pha   
0816 D8C6 A5 09                 lda   <ResID
0817 D8C8 48                    pha   
0818 D8C9 A2 1E 17 22           _ReleaseResource               ;attempt to load the resource from the file
0819 D8D0 B0 06                 bcs   UseROMData               ; if an error occured, us the ROM resource
0820 D8D2              ;
0821 D8D2
0822 D8D2 A0 00 00              ldy   #0                       ; error code ...
0823 D8D5 82 03 00              brl   GRRDone                  ; and end the call
0824 D8D8              ;
0825 D8D8              UseROMData  
0826 D8D8 A0 00 00              ldy   #0
0827 D8DB              ;
0828 D8DB              GRRDone   
0829 D8DB              ; This routine moves the return address on the stack and then tests <Y> for an
0830 D8DB              ; error code, and returns.
0831 D8DB
0832 D8DB A5 03                 lda   <RetAddr1                ; move the return address
0833 D8DD 85 09                 sta   <ResID
0834 D8DF A5 05                 lda   <RetAddr1+2
0835 D8E1 85 0B                 sta   <ResID+2
0836 D8E3 A5 07                 lda   <RetAddr1+4
0837 D8E5 85 0D                 sta   <ResID+4
0838 D8E7
0839 D8E7 2B                    pld                            ; recover the direct page
0840 D8E8 FA                    plx                            ; remove 6 bytes of data
0841 D8E9 FA                    plx   
0842 D8EA FA                    plx   
0843 D8EB
0844 D8EB 98                    tya                            ; put the return address into <A>
0845 D8EC C9 01 00              cmp   #1                       ; set the carry
0846 D8EF 6B                    rtl                            ; and leave
0847 D8F0                       EndP 
0848 D8F0
0849 D8F0                       END   
